import processing.core.*; 
import processing.data.*; 
import processing.opengl.*; 

import java.applet.*; 
import java.awt.Dimension; 
import java.awt.Frame; 
import java.awt.event.MouseEvent; 
import java.awt.event.KeyEvent; 
import java.awt.event.FocusEvent; 
import java.awt.Image; 
import java.io.*; 
import java.net.*; 
import java.text.*; 
import java.util.*; 
import java.util.zip.*; 
import java.util.regex.*; 

public class stfaa2 extends PApplet {

composition live_composition;

segment[][] singleLineLibrary = new segment[0][0];

segment[][] lineLibrary = new segment[0][0];

scrapeblock[][] scrapeblockGroups = new scrapeblock[0][0];

int backgroundColor = 0;

int loopCount = 0;

public void setup() {
  size(displayWidth, displayHeight); 
  //size(800, 600); 
  noCursor();
  noSmooth();
  noFill();
  strokeWeight(1);
  strokeJoin(ROUND);
  frameRate(60);
  //frame.setResizable(true);
  background(backgroundColor);
  live_composition = new singleline();
  //live_composition = new doubledraw();
}

public void draw() {
  live_composition.draw();
}

public void mouseMoved() {
  live_composition.mouseMoved();
}

public void mousePressed() {
  live_composition.mousePressed();
}

public void mouseDragged() {
  live_composition.mouseDragged();
}

public void mouseReleased() {
  live_composition.mouseReleased();
}

public segment[][] addLineToLineLibrary(segment[] currentLine, segment[][] library){
 library = (segment[][]) append(library, currentLine);
 return library;
}

//polygons get shaved off
/*
class Poly extends java.awt.Polygon {

   Poly(PVector[] points) {

    int[] xPoints = new int[0];
    int[] yPoints = new int[0];
    //int n = points.length;

    //for (PVector point : points) {
      //xPoints = (int[]) append(xPoints, point.x);
      //yPoints = (int[]) append(yPoints, point.y);
    //}
    
    //super(xPoints, yPoints, points.length);
  }

  void draw() {
    beginShape();
    for (int i = 0; i < npoints; i++) {
      vertex(xpoints[i], ypoints[i]);
    }
    endShape(CLOSE);
  }
  
  
}
*/

/*
class Poly extends java.awt.Polygon {
  public Poly(int[] x,int[] y, int n) {
    //call the java.awt.Polygon constructor
    super(x, y, n);
  }
 
  void drawMe() {
    beginShape();
    for (int i = 0; i < npoints; i++) {
      vertex(xpoints[i], ypoints[i]);
    }
    endShape(CLOSE);
  }
}
*/
class allLines extends composition {

  int backgroundColor = 0;
  int strokeColor = 255;
  int segPosModifier = 0;
  
  allLines() {
    background(255);
    stroke(0);
    drawAllLines();
  }

  public void draw() {
  }

  public void mouseMoved() {
  }

  public void mousePressed() {
  live_composition = new multiblocksrehash();
  }

  public void mouseReleased() {
    
  }

  public void mouseDragged() {
    
    //if(backgroundColor == 0) backgroundColor = 255;
    //else backgroundColor = 0;
    
    //if(strokeColor == 255) strokeColor = 0;
    //else strokeColor = 255;
    

    segPosModifier++;
  }

  public void drawAllLines(){
    for (segment[] Line : lineLibrary) {
      drawLineFromSegments(Line);
    }
  }

  public void drawLineFromSegments(segment[] segments) {
    beginShape(); 
    // for (int i = 0; i < numSegsToDraw; i++) {
    // if (i < segments.length) {
    // segment s = segments[i];
    for (segment s : segments) {
      vertex(s.x1, s.y1);
      vertex(s.x2, s.y2);
      //} else continue;
    }
    //}
    endShape();
  }
}

class composition {

  composition() {
  }

  public void draw() {
  }
  
  public void mouseMoved() {
  }

  public void mousePressed() {
  }

  public void mouseReleased() {
  }

  public void mouseDragged() {
  }
}

class dos extends composition {

  boolean drawLine = true;
  int releaseCount = -1;
  int gapCount = 0;
  
  dos() {
    stroke(255);
  }

  public void draw() {
  }

  public void mousePressed() {
  }

  public void mouseReleased() {
    releaseCount++;
    if(releaseCount == gapCount){
    drawLine = true;
    gapCount++;
    releaseCount = 0;
    } else drawLine = false;
  }

  public void mouseDragged() {
    if(drawLine) line(pmouseX,pmouseY,mouseX,mouseY);
  }
}

class doubledraw extends composition {

  segment[][] firstLineGroup  = new segment[0][0];
  segment[][] secondLineGroup = new segment[0][0];
  boolean addToFirst = true;
  segment[] currentLine;

  doubledraw() {
    stroke(255);
  }

  // maybe get to 20 strokes per side, then start combining strokes?

  public void draw() {
  }

  public void mouseMoved() {
  }

  public void mousePressed() {
    currentLine = new segment[0];
  }

  public void mouseReleased() {
    addToFirst = !addToFirst;

    if (addToFirst) {
      firstLineGroup = (segment[][]) append(firstLineGroup, currentLine);
        background(0);
        stroke(255);
      drawGroup(secondLineGroup);
    } 
    else {
      secondLineGroup = (segment[][]) append(secondLineGroup, currentLine);
        background(255);
        stroke(0);
      drawGroup(firstLineGroup);
    }

    println(firstLineGroup.length+" "+secondLineGroup.length);
  }

  public void mouseDragged() {
    segment s = new segment(pmouseX, pmouseY, mouseX, mouseY);
    currentLine = (segment[]) append(currentLine, s);
    line(pmouseX, pmouseY, mouseX, mouseY);
  }
}

public void drawGroup(segment[][] group) {


  for (segment[] segments : group) {

    beginShape();
    for (segment s : segments) {
      vertex(s.x1, s.y1);
      vertex(s.x2, s.y2);
    }
    endShape();
  }
}

class intersectors extends composition {


  PVector[][] lines = new PVector[0][0];
  PVector[] currentLine;
  segment[][] linesAsSegments = new segment[0][0];
  int polyIntersectCount = 0;
  int singleIntersectCount = 0;
  boolean checkSeparateLines = true;

  intersectors() {
    stroke(255);
  }

  public void draw() {
  }

  public void mousePressed() {
    lines = (PVector[][]) append(lines, new PVector[0]);
    currentLine = lines[lines.length - 1];
    currentLine = (PVector[]) append(currentLine, new PVector(mouseX, mouseY));
  }

  public void mouseReleased() {
    segment[] currentLineSegments = new segment[0];
    for (int currentPoint = currentLine.length-1; currentPoint > 0; currentPoint--) {
      segment seg = new segment(currentLine[currentPoint].x, currentLine[currentPoint].y, currentLine[currentPoint-1].x, currentLine[currentPoint-1].y); 
      currentLineSegments = (segment[]) append(currentLineSegments, seg);
    }
    linesAsSegments = (segment[][]) append(linesAsSegments, currentLineSegments);
    lineLibrary = addLineToLineLibrary(currentLineSegments, lineLibrary);
    // flow
    if (checkSeparateLines) {
      if (polyIntersectingLine()) {
        linesAsSegments = new segment[0][0];
        polyIntersectCount++;
        if(polyIntersectCount == 1) checkSeparateLines = false;
        background(backgroundColor);
      }
    }
    else{
     if(singleIntersectingLine(currentLineSegments, currentLineSegments)){
     singleIntersectCount++;
     if(singleIntersectCount == 1) live_composition = new multiblocks();
     background(backgroundColor);
     }
    }
  }

  public void mouseDragged() {
    currentLine = (PVector[]) append(currentLine, new PVector(mouseX, mouseY));
    stroke(255);
    line(pmouseX, pmouseY, mouseX, mouseY);
  }



  public boolean polyIntersectingLine() {
    for (segment[] lineToCheck : linesAsSegments) {
      for (segment[] otherLine : linesAsSegments) {
        if (lineToCheck == otherLine) {
        }
        else {
          if (singleIntersectingLine(lineToCheck, otherLine)) return true;
        }
      }
    }
    return false;
  }

  public boolean singleIntersectingLine(segment[] lineSegments, segment[] checkedLineSegments) {
    for (segment segToCheck : lineSegments) {
      for (segment otherSeg : checkedLineSegments) {
        if (segToCheck == otherSeg) {
        }
        else if (segToCheck.x1 == otherSeg.x2 && segToCheck.y1 == otherSeg.y2) {
        } 
        else if (segToCheck.x2 == otherSeg.x1 && segToCheck.y2 == otherSeg.y1) {
        }
        else { 
          if (segIntersection(segToCheck, otherSeg) != null) return true;
        }
      }
    }
    return false;
  }

  // from Ryan Alexander
  public PVector segIntersection(segment seg1, segment seg2) { 
    float bx = seg1.x2 - seg1.x1; 
    float by = seg1.y2 - seg1.y1; 
    float dx = seg2.x2 - seg2.x1; 
    float dy = seg2.y2 - seg2.y1;
    float b_dot_d_perp = bx * dy - by * dx;
    if (b_dot_d_perp == 0) {
      return null;
    }
    float cx = seg2.x1 - seg1.x1;
    float cy = seg2.y1 - seg1.y1;
    float t = (cx * dy - cy * dx) / b_dot_d_perp;
    if (t < 0 || t > 1) {
      return null;
    }
    float u = (cx * by - cy * bx) / b_dot_d_perp;
    if (u < 0 || u > 1) { 
      return null;
    }
    return new PVector(seg1.x1+t*bx, seg1.y1+t*by);
  }
}

class lockedline extends composition {

  boolean lockLine = false;

  lockedline() {
    stroke(255);
  }

  public void draw() {
  }

  public void mouseMoved() {
    if (lockLine) line(pmouseX, pmouseY, mouseX, mouseY);
  }

  public void mousePressed() {
    if (!lockLine) lockLine = true;
  }

  public void mouseReleased() {
  }

  public void mouseDragged() {
    if (lockLine) line(pmouseX, pmouseY, mouseX, mouseY);
  }
}

class multiblocks extends composition {

  scrapeblock[] scrapeblocks = new scrapeblock[0];

  int blockSizeMod = 1;

  multiblocks() {
    background(backgroundColor);
  }

  public void draw() {
  }

  public void mouseMoved() {
  }

  public void mousePressed() {
    //if (needNewBlock() || scrapeblocks.length == 0)
    addNewBlock();
    for (scrapeblock sb : scrapeblocks) {
      sb.mousePress();
    }
  }

  public void addNewBlock() {
    //if(blockSize
    scrapeblock newSb = new scrapeblock(mouseX-(width/(blockSizeMod)/2), mouseY-(height/(blockSizeMod)/2), blockSizeMod);
    scrapeblocks = (scrapeblock[]) append(scrapeblocks, newSb);
  }

  public void mouseReleased() {
    for (scrapeblock sb : scrapeblocks) {
      sb.mouseRelease();
    }
    blockSizeMod *= 2;
    if (blockSizeMod > 32*loopCount) {
      loopCount++;
      backgroundColor += loopCount * 25;
      println(backgroundColor);
      
      scrapeblockGroups = (scrapeblock[][]) append(scrapeblockGroups, scrapeblocks);
      
      if (loopCount < 5) { 
        live_composition = new singleline();
      }
      else live_composition = new allLines();
    }
  }

  public void mouseDragged() {
    background(backgroundColor);
    for (scrapeblock sb : scrapeblocks) {
      sb.mouseDrag();
    }
  }

  public boolean needNewBlock() {

    int blockCount = 0;

    for (scrapeblock sb : scrapeblocks) {
      if (sb.mouseInBlock(sb.b)) {
        blockCount++;
        return false;
      }
    }
    println(blockCount+" "+scrapeblocks.length);

    if (blockCount == (scrapeblocks.length)) {
      return false;
    } 
    else return true;
  }
}

class multiblocksrehash extends composition {

  multiblocksrehash() {
    background(0);
    drawGroupOfMultiBlocks();
  }

  public void draw() {
  }

  public void mouseMoved() {
  }

  public void mousePressed() {
  //exit();
  }

  public void mouseReleased() {
  exit();
  }

  public void mouseDragged() {
  }


  public void drawGroupOfMultiBlocks() {

    for (scrapeblock[] group : scrapeblockGroups) {
      for (scrapeblock sb : group) {
        sb.mouseDrag();
      }
    }
  }
}

class polygonpush extends composition {

  polygonpush() {
  }

  public void draw() {
  }
  
  public void mouseMoved() {
  }

  public void mousePressed() {
  }

  public void mouseReleased() {
  }

  public void mouseDragged() {
  }
}

class scrapeblock extends composition {

  int blockOriginX = (width/2) - ((width/4)/2);
  int blockOriginY = (height/2) - ((height/4)/2);
  block b;
  segment[] currentLine;
  segment[][] linesInsideBlock = new segment[0][0];
  segment[][] linesOutsideBlock = new segment[0][0];
  boolean startsInBlock;
  boolean segAppended;

  // begin by drawing lines through the square?

  scrapeblock(int origX, int origY, int sizeMod) {
    blockOriginX = origX;
    blockOriginY = origY;
    b = new block(width/sizeMod, height/sizeMod, blockOriginX, blockOriginY);
    b.draw();
  }

  public void draw() {
  }

  public void mouseMoved() {
  }

  public void mousePress() {
    if (mouseInBlock(b)) {
      startsInBlock = true;
    }
    else { 
      startsInBlock = false;
      stroke(255);
    }
    currentLine = new segment[0];
    segAppended = false;
  }

  public void mouseRelease() {
    if (!startsInBlock) {linesOutsideBlock = (segment[][]) append(linesOutsideBlock, currentLine);

    }
    else if (startsInBlock && !segAppended) {
      linesInsideBlock = (segment[][]) append(linesInsideBlock, currentLine);
      //lineLibrary = addLineToLineLibrary(currentLine, lineLibrary);
      isDrawing = false;
    }
  }

  boolean isDrawing = true;
  public void mouseDrag() {

    if (isDrawing) {
      if (startsInBlock) {
        if (mouseInBlock(b)) {
          currentLine = (segment[]) append(currentLine, new segment(pmouseX - b.x, pmouseY - b.y, mouseX - b.x, mouseY - b.y));
          //if (currentLine.length > 20) {
            //currentLine = (segment[]) subset(currentLine, 1);
          //}
        }
      } 
      else {
        currentLine = (segment[]) append(currentLine, new segment(pmouseX, pmouseY, mouseX, mouseY));
        stroke(255);
        for (segment s : currentLine) {
          // line(s.x1, s.y1, s.x2, s.y2);
        }
      }
    }

    if (startsInBlock && !mouseInBlock(b)) {
      b.x += mouseX - pmouseX;
      b.y += mouseY - pmouseY;
    }
    else if (!startsInBlock && mouseInBlock(b)) {
      b.x += mouseX - pmouseX;
      b.y += mouseY - pmouseY;
    }

    //drawLinesOutsideBlock();
    b.draw();
    drawLinesInsideBlock();

    if (mouseInBlock(b)) {
      stroke(255);
      for (segment s : currentLine) {
        line(b.x + s.x1, b.y + s.y1, b.x + s.x2, b.y + s.y2);
      }
    }
  }

  public void drawLinesInsideBlock() {

    stroke(255);
    //strokeCap(SQUARE);

    for (segment[] lines : linesInsideBlock) {
      for (segment seg : lines) {
        line(b.x+ seg.x1, b.y + seg.y1, b.x + seg.x2, b.y + seg.y2);
      }
    }
  }

  public void drawLinesOutsideBlock() {

    stroke(255);
    strokeCap(SQUARE);

    for (segment[] lines : linesOutsideBlock) {
      for (segment seg : lines) {
        line(seg.x1, seg.y1, seg.x2, seg.y2);
      }
    }
  }

  public boolean mouseInBlock(block blockToCheck) {
    if (mouseX >= b.x && mouseX <= (b.x + b.w)) {
      if (mouseY >= b.y && mouseY <= (b.y+ b.h)) {
        return true;
      }
    }
    return false;
  }
}

class block {

  int w;
  int h;
  int x;
  int y;

  block(int blockWidth, int blockHeight, int xPos, int yPos) {
    w = blockWidth;
    h = blockHeight;
    x = xPos;
    y = yPos;
  }

  public void draw() {
    noStroke();
    //stroke(255,0,0);
    //fill(255);
    rect(x, y, w, h);
  }
}

class segment {

  float x1, y1, x2, y2;

  segment(float X1, float Y1, float X2, float Y2) {

    x1 = X1;
    y1 = Y1;
    x2 = X2;
    y2 = Y2;
  }
}
class singleline extends composition {

  boolean wasDragged = false;
  int lineCount = 0;
  int numSegsToDraw = 0;
  segment[] currentLine;

  singleline() {
    stroke(255);
  }

  public void draw() {
  }

  public void mouseMoved() {
  }

  public void mousePressed() {
    currentLine = new segment[0];
  }

  public void mouseReleased() {
    if (wasDragged) {
      lineCount++;
      wasDragged = false;
      singleLineLibrary = addLineToLineLibrary(currentLine, singleLineLibrary);
      if (lineCount == 1) {
        live_composition = new intersectors();
      }
    }
    background(backgroundColor);
  }

  public void mouseDragged() {
    if(pmouseX == 0 && pmouseY == 0) return;
    background(backgroundColor);
    segment s = new segment(pmouseX, pmouseY, mouseX, mouseY);
    currentLine = (segment[]) append(currentLine, s);
    drawLineFromSegments(currentLine, currentLine.length);
    wasDragged = true;

    for (segment[] Line : singleLineLibrary) {
      drawLineFromSegments(Line, numSegsToDraw);
    }
    numSegsToDraw++;
  }
}

public void drawLineFromSegments(segment[] segments, int numSegsToDraw) {
  beginShape(); 
    for (int i = 0; i < numSegsToDraw; i++) {
      if (i < segments.length) {
      segment s = segments[i];
      //for (segment s : segments) {
      vertex(s.x1, s.y1);
      vertex(s.x2, s.y2);
      } else continue;
    }
  //}
  endShape();
}

class uno extends composition {

  int releaseCount = 1;
  int gapCount = 0;
  boolean gapInc = true;

  uno() {
  }

  public void draw() {
  }

  public void mousePressed() {
    if(releaseCount > gapCount){
    background(255);
    releaseCount = 0;
    if(gapInc) gapCount++;
    else gapCount--;
    }
    if(gapCount == 3 && gapInc || gapCount == 0 && !gapInc){
    gapInc = !gapInc;
    println(gapInc);
    }
    println(gapCount);
  }

  public void mouseReleased() {
   
    //if(releaseCount > random(10)) gapCount++;
    background(0);
    releaseCount++;
    //live_composition = new dos();
  }

  public void mouseDragged() {
  }
  
  
  
  
}

  static public void main(String[] passedArgs) {
    String[] appletArgs = new String[] { "--full-screen", "--bgcolor=#666666", "--hide-stop", "stfaa2" };
    if (passedArgs != null) {
      PApplet.main(concat(appletArgs, passedArgs));
    } else {
      PApplet.main(appletArgs);
    }
  }
}
